<?php
/**
 * Plugin Name: درگاه پرداخت سپال برای ووکامرس
 * Plugin URI: https://sepal.ir
 * Description: افزونه درگاه پرداخت امن سپال برای فروشگاه‌ساز ووکامرس.
 * Version: 1.1.0
 * Author: Sepal Payment
 * Author URI: https://sepal.ir
 * Text Domain: woocommerce-sepal-gateway
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP: 7.2
 */

if (!defined('ABSPATH')) {
    exit;
}

// 1. اعلام سازگاری با HPOS (بسیار مهم برای ووکامرس‌های جدید)
add_action('before_woocommerce_init', 'sepal_gateway_hpos_compatibility');
function sepal_gateway_hpos_compatibility() {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
}

// 2. هوک اصلی برای لود کردن کلاس درگاه
add_action('plugins_loaded', 'init_sepal_gateway_class', 0);

function init_sepal_gateway_class() {
    // اگر ووکامرس نصب نیست، کاری نکن
    if (!class_exists('WC_Payment_Gateway')) {
        return;
    }

    /**
     * کلاس اصلی درگاه پرداخت سپال
     */
    class WC_Sepal extends WC_Payment_Gateway
    {
        private $apiKey;
        private $failedMassage;
        private $successMassage;

        public function __construct()
        {
            $this->id = 'WC_Sepal';
            $this->method_title = __('درگاه پرداخت سپال', 'woocommerce-sepal-gateway');
            $this->method_description = __('تنظیمات درگاه پرداخت سپال برای افزونه فروشگاه ساز ووکامرس', 'woocommerce-sepal-gateway');
            $this->icon = apply_filters('WC_Sepal_logo', plugin_dir_url(__FILE__) . 'assets/images/logo.png');
            $this->has_fields = false;

            // پشتیبانی از ویژگی‌های استاندارد
            $this->supports = ['products'];

            $this->init_form_fields();
            $this->init_settings();

            $this->title = $this->settings['title'];
            $this->description = $this->settings['description'];
            $this->apiKey = $this->settings['apiKey'];
            $this->successMassage = $this->settings['success_massage'];
            $this->failedMassage = $this->settings['failed_massage'];

            if (version_compare(WOOCOMMERCE_VERSION, '2.0.0', '>=')) {
                add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
            } else {
                add_action('woocommerce_update_options_payment_gateways', array($this, 'process_admin_options'));
            }

            add_action('woocommerce_receipt_' . $this->id, array($this, 'Send_to_Sepal_Gateway'));
            add_action('woocommerce_api_' . strtolower(get_class($this)), array($this, 'Return_from_Sepal_Gateway'));
        }

        public function init_form_fields()
        {
            $this->form_fields = apply_filters('WC_Sepal_Config', array(
                'base_config' => array(
                    'title' => __('تنظیمات پایه ای', 'woocommerce-sepal-gateway'),
                    'type' => 'title',
                    'description' => '',
                ),
                'enabled' => array(
                    'title' => __('فعالسازی/غیرفعالسازی', 'woocommerce-sepal-gateway'),
                    'type' => 'checkbox',
                    'label' => __('فعالسازی درگاه سپال', 'woocommerce-sepal-gateway'),
                    'description' => __('برای فعالسازی درگاه پرداخت سپال باید چک باکس را تیک بزنید', 'woocommerce-sepal-gateway'),
                    'default' => 'yes',
                    'desc_tip' => true,
                ),
                'title' => array(
                    'title' => __('عنوان درگاه', 'woocommerce-sepal-gateway'),
                    'type' => 'text',
                    'description' => __('عنوان درگاه که در طی خرید به مشتری نمایش داده میشود', 'woocommerce-sepal-gateway'),
                    'default' => __('درگاه پرداخت سپال', 'woocommerce-sepal-gateway'),
                    'desc_tip' => true,
                ),
                'description' => array(
                    'title' => __('توضیحات درگاه', 'woocommerce-sepal-gateway'),
                    'type' => 'text',
                    'desc_tip' => true,
                    'description' => __('توضیحاتی که در هنگام انجام پرداخت برای این درگاه نمایش داده می شود', 'woocommerce-sepal-gateway'),
                    'default' => __('پرداخت به وسیله کلیه کارت های عضو شبکه شتاب از طریق درگاه آنلاین سپال', 'woocommerce-sepal-gateway')
                ),
                'apiKey' => array(
                    'title' => __('کلید وب سرویس', 'woocommerce-sepal-gateway'),
                    'type' => 'text',
                    'description' => __('کلید وب سرویس درگاه سپال', 'woocommerce-sepal-gateway'),
                    'default' => '',
                    'desc_tip' => true
                ),
                'payment_config' => array(
                    'title' => __('تنظیمات عملیات پرداخت', 'woocommerce-sepal-gateway'),
                    'type' => 'title',
                    'description' => '',
                ),
                'success_massage' => array(
                    'title' => __('پیام پرداخت موفق', 'woocommerce-sepal-gateway'),
                    'type' => 'textarea',
                    'description' => __('متن پیامی که میخواهید بعد از پرداخت موفق به کاربر نمایش دهید را وارد نمایید . همچنین می توانید از شورت کد {payment_number} برای نمایش شماره پرداخت سپال استفاده نمایید .', 'woocommerce-sepal-gateway'),
                    'default' => __('با تشکر از شما . سفارش شما با موفقیت پرداخت شد .', 'woocommerce-sepal-gateway'),
                ),
                'failed_massage' => array(
                    'title' => __('پیام پرداخت ناموفق', 'woocommerce-sepal-gateway'),
                    'type' => 'textarea',
                    'description' => __('متن پیامی که میخواهید بعد از پرداخت ناموفق به کاربر نمایش دهید را وارد نمایید . همچنین می توانید از شورت کد {fault} برای نمایش دلیل خطای رخ داده استفاده نمایید.', 'woocommerce-sepal-gateway'),
                    'default' => __('پرداخت شما ناموفق بوده است . لطفا مجددا تلاش نمایید یا در صورت بروز اشکال با مدیر سایت تماس بگیرید .', 'woocommerce-sepal-gateway'),
                ),
            ));
        }

        public function process_payment($order_id)
        {
            $order = new WC_Order($order_id);
            return array(
                'result' => 'success',
                'redirect' => $order->get_checkout_payment_url(true)
            );
        }

        public function SendRequestToSepal($action, $params)
        {
            try {
                $ch = curl_init('https://sepal.ir/api/' . $action . '.json');
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
                curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $result = curl_exec($ch);
                return json_decode($result, true);
            } catch (Exception $ex) {
                return false;
            }
        }

        public function Send_to_Sepal_Gateway($order_id)
        {
            global $woocommerce;
            $woocommerce->session->order_id_sepal = $order_id;
            $order = new WC_Order($order_id);
            $currency = $order->get_currency();
            $currency = apply_filters('WC_Sepal_Currency', $currency, $order_id);

            $form = '<form action="" method="POST" class="sepal-checkout-form" id="sepal-checkout-form">
                        <input type="submit" name="sepal_submit" class="button alt" id="sepal-payment-button" value="' . __('پرداخت', 'woocommerce-sepal-gateway') . '"/>
                        <a class="button cancel" href="' . $woocommerce->cart->get_checkout_url() . '">' . __('بازگشت', 'woocommerce-sepal-gateway') . '</a>
                     </form><br/>';
            $form = apply_filters('WC_Sepal_Form', $form, $order_id, $woocommerce);

            do_action('WC_Sepal_Gateway_Before_Form', $order_id, $woocommerce);
            echo $form;
            do_action('WC_Sepal_Gateway_After_Form', $order_id, $woocommerce);

            $Amount = (int)$order->get_total();
            $Amount = apply_filters('woocommerce_order_amount_total_IRANIAN_gateways_before_check_currency', $Amount, $currency);

            $strToLowerCurrency = strtolower($currency);
            if (in_array($strToLowerCurrency, ['irt', 'toman', 'iran toman', 'iranian toman', 'تومان', 'تومان ایران'])) {
                $Amount *= 10;
            } else if ($strToLowerCurrency === 'irht') {
                $Amount *= 10000;
            } else if ($strToLowerCurrency === 'irhr') {
                $Amount *= 1000;
            }

            $CallbackUrl = add_query_arg('wc_order', $order_id, WC()->api_request_url('WC_Sepal'));
            $Description = 'خرید به شماره سفارش : ' . $order->get_order_number();

            $data = array(
                'apiKey' => $this->apiKey,
                'amount' => $Amount,
                'callbackUrl' => $CallbackUrl,
                'invoiceNumber' => $order_id,
                'description' => $Description,
            );

            $result = $this->SendRequestToSepal('request', json_encode($data));

            if ($result === false) {
                echo 'cURL Error';
            } else if (isset($result['status']) && $result['status']) {
                $paymentUrl = 'https://sepal.ir/payment/' . $result['paymentNumber'];
                wp_redirect($paymentUrl);
                exit;
            } else {
                $Message = isset($result['message']) ? $result['message'] : 'خطای ناشناخته';
                wc_add_notice($Message, 'error');
            }
        }

        public function Return_from_Sepal_Gateway()
        {
            $InvoiceNumber = isset($_POST['invoiceNumber']) ? $_POST['invoiceNumber'] : '';
            global $woocommerce;

            if (isset($_GET['wc_order'])) {
                $order_id = $_GET['wc_order'];
            } else if ($InvoiceNumber) {
                $order_id = $InvoiceNumber;
            } else {
                $order_id = $woocommerce->session->order_id_sepal;
                unset($woocommerce->session->order_id_sepal);
            }

            if ($order_id) {
                $order = new WC_Order($order_id);
                if ($order->status !== 'completed') {
                    if (isset($_POST['status']) && $_POST['status'] == 1) {
                        $paymentNumber = $_POST['paymentNumber'];
                        $data = array(
                            'apiKey' => $this->apiKey,
                            'paymentNumber' => $paymentNumber,
                            'invoiceNumber' => $order_id,
                        );
                        $result = $this->SendRequestToSepal('verify', json_encode($data));

                        if (isset($result['status']) && $result['status']) {
                            $order->payment_complete($paymentNumber);
                            $woocommerce->cart->empty_cart();
                            $order->add_order_note(sprintf(__('پرداخت موفقیت آمیز بود. کد رهگیری: %s', 'woocommerce-sepal-gateway'), $paymentNumber));
                            wp_redirect($this->get_return_url($order));
                            exit;
                        }
                    }
                }
            }
            wp_redirect($woocommerce->cart->get_checkout_url());
            exit;
        }
    }

    // 3. افزودن کلاس به لیست درگاه‌های ووکامرس
    add_filter('woocommerce_payment_gateways', 'add_sepal_gateway_class');
}

function add_sepal_gateway_class($methods) {
    $methods[] = 'WC_Sepal';
    return $methods;
}

// 4. توابع کمکی ارزها
add_filter('woocommerce_currencies', 'Sepal_add_IR_currency');
function Sepal_add_IR_currency($currencies) {
    $currencies['IRR'] = __('ریال', 'woocommerce-sepal-gateway');
    $currencies['IRT'] = __('تومان', 'woocommerce-sepal-gateway');
    $currencies['IRHR'] = __('هزار ریال', 'woocommerce-sepal-gateway');
    $currencies['IRHT'] = __('هزار تومان', 'woocommerce-sepal-gateway');
    return $currencies;
}

add_filter('woocommerce_currency_symbol', 'Sepal_add_IR_currency_symbol', 10, 2);
function Sepal_add_IR_currency_symbol($currency_symbol, $currency) {
    switch ($currency) {
        case 'IRR': $currency_symbol = 'ریال'; break;
        case 'IRT': $currency_symbol = 'تومان'; break;
        case 'IRHR': $currency_symbol = 'هزار ریال'; break;
        case 'IRHT': $currency_symbol = 'هزار تومان'; break;
    }
    return $currency_symbol;
}

// 5. هوک برای فعال‌سازی در بخش بلوک‌های جدید (Blocks)
add_action('woocommerce_blocks_loaded', 'sepal_register_checkout_block');

function sepal_register_checkout_block() {
    if (!class_exists('Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType')) {
        return;
    }

    require_once plugin_dir_path(__FILE__) . 'class-sepal-block.php';

    add_action(
        'woocommerce_blocks_payment_method_type_registration',
        function(Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry) {
            $payment_method_registry->register(new WC_Sepal_Blocks_Support());
        }
    );
}
?>
