<?php
use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class WC_Sepal_Blocks_Support extends AbstractPaymentMethodType {

    private $gateway;
    protected $name = 'WC_Sepal'; // باید با ID کلاس اصلی یکی باشد

    public function initialize() {
        $this->settings = get_option('woocommerce_WC_Sepal_settings', []);
        $this->gateway = new WC_Sepal();
    }

    public function is_active() {
        return $this->gateway->is_available();
    }

    public function get_payment_method_script_handles() {
        wp_register_script(
            'wc-sepal-blocks-integration',
            plugin_dir_url(__FILE__) . 'assets/js/sepal-checkout.js',
            [
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
            ],
            null,
            true
        );

        return ['wc-sepal-blocks-integration'];
    }

    public function get_payment_method_data() {
        return [
            'title' => $this->gateway->title,
            'description' => $this->gateway->description,
            'icon' => $this->gateway->icon,
            'supports' => array_filter($this->gateway->supports, [ $this->gateway, 'supports' ])
        ];
    }
}
