const sepal_settings = window.wc.wcSettings.getSetting("WC_Sepal_data", {});

const sepal_label =
  window.wp.htmlEntities.decodeEntities(sepal_settings.title) ||
  window.wp.i18n.__("درگاه پرداخت سپال", "woocommerce-sepal-gateway");

const sepal_Content = () => {
  return window.wp.htmlEntities.decodeEntities(
    sepal_settings.description ||
      "پرداخت امن به وسیله کلیه کارت های عضو شتاب از طریق درگاه سپال"
  );
};

const sepal_label_with_icon = window.wp.element.createElement(
  "span",
  {
    style: {
      display: "inline-flex",
      alignItems: "center",
      gap: "10px",
      direction: "rtl",
    },
  },
  sepal_settings.icon ? window.wp.element.createElement("img", {
    src: sepal_settings.icon,
    alt: sepal_label,
    style: { height: "30px" },
  }) : null,
  sepal_label
);

const Sepal_Block_Gateway = {
  name: "WC_Sepal",
  label: sepal_label_with_icon,
  content: window.wp.element.createElement(sepal_Content, null),
  edit: window.wp.element.createElement(sepal_Content, null),
  canMakePayment: () => true,
  ariaLabel: sepal_label,
  supports: {
    features: sepal_settings.supports,
  },
};

window.wc.wcBlocksRegistry.registerPaymentMethod(Sepal_Block_Gateway);
